//#include <ntddk.h> // in here, the use of header file is only on the type define.
#include <linux/kernel.h>

#include "DriverInfo.h"

#include "SPtype.h"
#include "funcresult.h"

#include "DrvDebug.h"

#include "BusDeviceIO.h"

#include "HwiEUART.h"

// in Hwi level, we dont check the result of BusDeviceIO_func.

VOID
_SetHwiDivisorLatchLowReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDivisorLatchLowReg      pHwiDivisorLatchLowReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = pHwiDivisorLatchLowReg->Data;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDivisorLatchLowReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDivisorLatchLowReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDivisorLatchLowReg      pHwiDivisorLatchLowReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDivisorLatchLowReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiDivisorLatchLowReg->Data = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}

VOID
_ShowHwiDivisorLatchLowReg(
    IN      PHwiDivisorLatchLowReg      pHwiDivisorLatchLowReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiDivisorLatchLowReg_Data:0x%0.8X \n", pHwiDivisorLatchLowReg->Data);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDivisorLatchHighReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDivisorLatchHighReg     pHwiDivisorLatchHighReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = pHwiDivisorLatchHighReg->Data;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDivisorLatchHighReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDivisorLatchHighReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDivisorLatchHighReg     pHwiDivisorLatchHighReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDivisorLatchHighReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiDivisorLatchHighReg->Data = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiDivisorLatchHighReg(
    IN      PHwiDivisorLatchHighReg     pHwiDivisorLatchHighReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiDivisorLatchHighReg_Data:0x%0.8X \n", pHwiDivisorLatchHighReg->Data);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiReceiverBufferReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiReceiverBufferReg       pHwiReceiverBufferReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiReceiverBufferReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiReceiverBufferReg->Data = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiReceiverBufferReg(
    IN      PHwiReceiverBufferReg       pHwiReceiverBufferReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiReceiverBufferReg_Data:0x%0.8X \n", pHwiReceiverBufferReg->Data);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiTransmitterHoldingReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiTransmitterHoldingReg   pHwiTransmitterHoldingReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = pHwiTransmitterHoldingReg->Data;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiTransmitterHoldingReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiInterruptEnableReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiInterruptEnableReg      pHwiInterruptEnableReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiInterruptEnableReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiInterruptEnableReg_ReceivedDataAvailable, pHwiInterruptEnableReg->ReceivedDataAvailable);
    _SetDataField(Value, HwiInterruptEnableReg_TransmitterHoldingEmpty, pHwiInterruptEnableReg->TransmitterHoldingEmpty);
    _SetDataField(Value, HwiInterruptEnableReg_LineStatus, pHwiInterruptEnableReg->LineStatus);
    _SetDataField(Value, HwiInterruptEnableReg_ModemStatus, pHwiInterruptEnableReg->ModemStatus);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiInterruptEnableReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiInterruptEnableReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiInterruptEnableReg      pHwiInterruptEnableReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiInterruptEnableReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiInterruptEnableReg_ReceivedDataAvailable, pHwiInterruptEnableReg->ReceivedDataAvailable);
    _GetDataField(Value, HwiInterruptEnableReg_TransmitterHoldingEmpty, pHwiInterruptEnableReg->TransmitterHoldingEmpty);
    _GetDataField(Value, HwiInterruptEnableReg_LineStatus, pHwiInterruptEnableReg->LineStatus);
    _GetDataField(Value, HwiInterruptEnableReg_ModemStatus, pHwiInterruptEnableReg->ModemStatus);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiInterruptEnableReg(
    IN      PHwiInterruptEnableReg      pHwiInterruptEnableReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiInterruptEnableReg_ReceivedDataAvailable:0x%0.8X \n", pHwiInterruptEnableReg->ReceivedDataAvailable);
    DrvDbgPrint(DMT_Info, "HwiInterruptEnableReg_TransmitterHoldingEmpty:0x%0.8X \n", pHwiInterruptEnableReg->TransmitterHoldingEmpty);
    DrvDbgPrint(DMT_Info, "HwiInterruptEnableReg_LineStatus:0x%0.8X \n", pHwiInterruptEnableReg->LineStatus);
    DrvDbgPrint(DMT_Info, "HwiInterruptEnableReg_ModemStatus:0x%0.8X \n", pHwiInterruptEnableReg->ModemStatus);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiInterruptIdentificationReg(
    IN      PMappedBusAddress                   hMappedRegisters,
        OUT PHwiInterruptIdentificationReg      pHwiInterruptIdentificationReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiInterruptIdentificationReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiInterruptIdentificationReg_NoPending, pHwiInterruptIdentificationReg->NoPending);
    _GetDataField(Value, HwiInterruptIdentificationReg_ID, pHwiInterruptIdentificationReg->ID);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiInterruptIdentificationReg(
    IN      PHwiInterruptIdentificationReg  pHwiInterruptIdentificationReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiInterruptIdentificationReg_NoPending:0x%0.8X \n", pHwiInterruptIdentificationReg->NoPending);
    DrvDbgPrint(DMT_Info, "HwiInterruptIdentificationReg_ID:0x%0.8X \n", pHwiInterruptIdentificationReg->ID);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiFIFOControlReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiFIFOControlReg          pHwiFIFOControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    _SetDataField(Value, HwiFIFOControlReg_FIFOEnable, pHwiFIFOControlReg->FIFOEnable);
    _SetDataField(Value, HwiFIFOControlReg_RxFIFOReset, pHwiFIFOControlReg->RxFIFOReset);
    _SetDataField(Value, HwiFIFOControlReg_TxFIFOReset, pHwiFIFOControlReg->TxFIFOReset);
    _SetDataField(Value, HwiFIFOControlReg_RxFIFOTriggerLevel, pHwiFIFOControlReg->RxFIFOTriggerLevel);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiFIFOControlReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiLineControlReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiLineControlReg          pHwiLineControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiLineControlReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiLineControlReg_WordLengthSelect, pHwiLineControlReg->WordLengthSelect);
    _SetDataField(Value, HwiLineControlReg_StopBitsSelect, pHwiLineControlReg->StopBitsSelect);
    _SetDataField(Value, HwiLineControlReg_ParityEnable, pHwiLineControlReg->ParityEnable);
    _SetDataField(Value, HwiLineControlReg_ParitySelect, pHwiLineControlReg->ParitySelect);
    _SetDataField(Value, HwiLineControlReg_TransmitBreak, pHwiLineControlReg->TransmitBreak);
    _SetDataField(Value, HwiLineControlReg_DivisorLatchAccess, pHwiLineControlReg->DivisorLatchAccess);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiLineControlReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiLineControlReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiLineControlReg          pHwiLineControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiLineControlReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiLineControlReg_WordLengthSelect, pHwiLineControlReg->WordLengthSelect);
    _GetDataField(Value, HwiLineControlReg_StopBitsSelect, pHwiLineControlReg->StopBitsSelect);
    _GetDataField(Value, HwiLineControlReg_ParityEnable, pHwiLineControlReg->ParityEnable);
    _GetDataField(Value, HwiLineControlReg_ParitySelect, pHwiLineControlReg->ParitySelect);
    _GetDataField(Value, HwiLineControlReg_TransmitBreak, pHwiLineControlReg->TransmitBreak);
    _GetDataField(Value, HwiLineControlReg_DivisorLatchAccess, pHwiLineControlReg->DivisorLatchAccess);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiLineControlReg(
    IN      PHwiLineControlReg          pHwiLineControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_WordLengthSelect:0x%0.8X \n", pHwiLineControlReg->WordLengthSelect);
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_StopBitsSelect:0x%0.8X \n", pHwiLineControlReg->StopBitsSelect);
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_ParityEnable:0x%0.8X \n", pHwiLineControlReg->ParityEnable);
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_ParitySelect:0x%0.8X \n", pHwiLineControlReg->ParitySelect);
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_TransmitBreak:0x%0.8X \n", pHwiLineControlReg->TransmitBreak);
    DrvDbgPrint(DMT_Info, "HwiLineControlReg_DivisorLatchAccess:0x%0.8X \n", pHwiLineControlReg->DivisorLatchAccess);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiModemControlReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiModemControlReg         pHwiModemControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiModemControlReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiModemControlReg_DTRPin, pHwiModemControlReg->DTRPin);
    _SetDataField(Value, HwiModemControlReg_RTSPin, pHwiModemControlReg->RTSPin);
    _SetDataField(Value, HwiModemControlReg_Out1Pin, pHwiModemControlReg->Out1Pin);
    _SetDataField(Value, HwiModemControlReg_Out2Pin, pHwiModemControlReg->Out2Pin);
    _SetDataField(Value, HwiModemControlReg_LoopbackEnable, pHwiModemControlReg->LoopbackEnable);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiModemControlReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiModemControlReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiModemControlReg         pHwiModemControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiModemControlReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiModemControlReg_DTRPin, pHwiModemControlReg->DTRPin);
    _GetDataField(Value, HwiModemControlReg_RTSPin, pHwiModemControlReg->RTSPin);
    _GetDataField(Value, HwiModemControlReg_Out1Pin, pHwiModemControlReg->Out1Pin);
    _GetDataField(Value, HwiModemControlReg_Out2Pin, pHwiModemControlReg->Out2Pin);
    _GetDataField(Value, HwiModemControlReg_LoopbackEnable, pHwiModemControlReg->LoopbackEnable);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiModemControlReg(
    IN      PHwiModemControlReg         pHwiModemControlReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiModemControlReg_DTRPin:0x%0.8X \n", pHwiModemControlReg->DTRPin);
    DrvDbgPrint(DMT_Info, "HwiModemControlReg_RTSPin:0x%0.8X \n", pHwiModemControlReg->RTSPin);
    DrvDbgPrint(DMT_Info, "HwiModemControlReg_Out1Pin:0x%0.8X \n", pHwiModemControlReg->Out1Pin);
    DrvDbgPrint(DMT_Info, "HwiModemControlReg_Out2Pin:0x%0.8X \n", pHwiModemControlReg->Out2Pin);
    DrvDbgPrint(DMT_Info, "HwiModemControlReg_LoopbackEnable:0x%0.8X \n", pHwiModemControlReg->LoopbackEnable);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiLineStatusReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiLineStatusReg           pHwiLineStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiLineStatusReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiLineStatusReg_DataReady, pHwiLineStatusReg->DataReady);
    _GetDataField(Value, HwiLineStatusReg_OverrunError, pHwiLineStatusReg->OverrunError);
    _GetDataField(Value, HwiLineStatusReg_ParityError, pHwiLineStatusReg->ParityError);
    _GetDataField(Value, HwiLineStatusReg_FamingError, pHwiLineStatusReg->FamingError);
    _GetDataField(Value, HwiLineStatusReg_BreakSignal, pHwiLineStatusReg->BreakSignal);
    _GetDataField(Value, HwiLineStatusReg_TransmitterHodingEmpty, pHwiLineStatusReg->TransmitterHodingEmpty);
    _GetDataField(Value, HwiLineStatusReg_TransmitterEmpty, pHwiLineStatusReg->TransmitterEmpty);
    _GetDataField(Value, HwiLineStatusReg_ErrorInRxFIFO, pHwiLineStatusReg->ErrorInRxFIFO);
    
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiLineStatusReg(
    IN      PHwiLineStatusReg           pHwiLineStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_DataReady:0x%0.8X \n", pHwiLineStatusReg->DataReady);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_OverrunError:0x%0.8X \n", pHwiLineStatusReg->OverrunError);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_ParityError:0x%0.8X \n", pHwiLineStatusReg->ParityError);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_FamingError:0x%0.8X \n", pHwiLineStatusReg->FamingError);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_BreakSignal:0x%0.8X \n", pHwiLineStatusReg->BreakSignal);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_TransmitterHodingEmpty:0x%0.8X \n", pHwiLineStatusReg->TransmitterHodingEmpty);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_TransmitterEmpty:0x%0.8X \n", pHwiLineStatusReg->TransmitterEmpty);
    DrvDbgPrint(DMT_Info, "HwiLineStatusReg_ErrorInRxFIFO:0x%0.8X \n", pHwiLineStatusReg->ErrorInRxFIFO);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiModemStatusReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiModemStatusReg          pHwiModemStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiModemStatusReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiModemStatusReg_CTSChange, pHwiModemStatusReg->CTSChange);
    _GetDataField(Value, HwiModemStatusReg_DSRChange, pHwiModemStatusReg->DSRChange);
    _GetDataField(Value, HwiModemStatusReg_RIChange, pHwiModemStatusReg->RIChange);
    _GetDataField(Value, HwiModemStatusReg_DCDChange, pHwiModemStatusReg->DCDChange);
    _GetDataField(Value, HwiModemStatusReg_CTS, pHwiModemStatusReg->CTS);
    _GetDataField(Value, HwiModemStatusReg_DSR, pHwiModemStatusReg->DSR);
    _GetDataField(Value, HwiModemStatusReg_RI, pHwiModemStatusReg->RI);
    _GetDataField(Value, HwiModemStatusReg_DCD, pHwiModemStatusReg->DCD);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiModemStatusReg(
    IN      PHwiModemStatusReg          pHwiModemStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //

    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_CTSChange:0x%0.8X \n", pHwiModemStatusReg->CTSChange);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_DSRChange:0x%0.8X \n", pHwiModemStatusReg->DSRChange);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_RIChange:0x%0.8X \n", pHwiModemStatusReg->RIChange);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_DCDChange:0x%0.8X \n", pHwiModemStatusReg->DCDChange);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_CTS:0x%0.8X \n", pHwiModemStatusReg->CTS);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_DSR:0x%0.8X \n", pHwiModemStatusReg->DSR);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_RI:0x%0.8X \n", pHwiModemStatusReg->RI);
    DrvDbgPrint(DMT_Info, "HwiModemStatusReg_DCD:0x%0.8X \n", pHwiModemStatusReg->DCD);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiScratchpadReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiScratchpadReg           pHwiScratchpadReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = pHwiScratchpadReg->Data;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiScratchpadReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiScratchpadReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiScratchpadReg           pHwiScratchpadReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiScratchpadReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiScratchpadReg->Data = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_ShowHwiScratchpadReg(
    IN      PHwiScratchpadReg           pHwiScratchpadReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    //ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    //if (hMappedRegisters == NULL)
    //{
        //funcFR_Error;
        //goto funcexit;
    //}
    
    //
    // function body
    //
    
    DrvDbgPrint(DMT_Info, "HwiScratchpadReg_Data:0x%0.8X \n", pHwiScratchpadReg->Data);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}



VOID
_SetHwiDMAControl0Reg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMAControl0Reg          pHwiDMAControl0Reg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl0Reg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiDMAControl0Reg_DMAEnable, pHwiDMAControl0Reg->DMAEnable);
    _SetDataField(Value, HwiDMAControl0Reg_HardReset, pHwiDMAControl0Reg->HardReset);
    _SetDataField(Value, HwiDMAControl0Reg_RxSegmentTriggerLevel, pHwiDMAControl0Reg->RxSegmentTriggerLevel);
    _SetDataField(Value, HwiDMAControl0Reg_DebugBit, pHwiDMAControl0Reg->DebugBit);
    
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl0Reg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMAControl0Reg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMAControl0Reg          pHwiDMAControl0Reg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl0Reg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiDMAControl0Reg_DMAEnable, pHwiDMAControl0Reg->DMAEnable);
    _GetDataField(Value, HwiDMAControl0Reg_HardReset, pHwiDMAControl0Reg->HardReset);
    _GetDataField(Value, HwiDMAControl0Reg_RxSegmentTriggerLevel, pHwiDMAControl0Reg->RxSegmentTriggerLevel);
    _GetDataField(Value, HwiDMAControl0Reg_DebugBit, pHwiDMAControl0Reg->DebugBit);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMAControl1Reg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMAControl1Reg          pHwiDMAControl1Reg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl1Reg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiDMAControl1Reg_TxSegment0Ready, pHwiDMAControl1Reg->TxSegment0Ready);
    _SetDataField(Value, HwiDMAControl1Reg_TxSegment1Ready, pHwiDMAControl1Reg->TxSegment1Ready);
    _SetDataField(Value, HwiDMAControl1Reg_RxSegment0Ready, pHwiDMAControl1Reg->RxSegment0Ready);
    _SetDataField(Value, HwiDMAControl1Reg_RxSegment1Ready, pHwiDMAControl1Reg->RxSegment1Ready);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl1Reg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMAControl1Reg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMAControl1Reg          pHwiDMAControl1Reg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAControl1Reg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiDMAControl1Reg_TxSegment0Ready, pHwiDMAControl1Reg->TxSegment0Ready);
    _GetDataField(Value, HwiDMAControl1Reg_TxSegment1Ready, pHwiDMAControl1Reg->TxSegment1Ready);
    _GetDataField(Value, HwiDMAControl1Reg_RxSegment0Ready, pHwiDMAControl1Reg->RxSegment0Ready);
    _GetDataField(Value, HwiDMAControl1Reg_RxSegment1Ready, pHwiDMAControl1Reg->RxSegment1Ready);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMAStatusReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMAStatusReg            pHwiDMAStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAStatusReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiDMAStatusReg_TxSegmentIndication, pHwiDMAStatusReg->TxSegmentIndication);
    _GetDataField(Value, HwiDMAStatusReg_RxSegmentIndication, pHwiDMAStatusReg->RxSegmentIndication);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMATxBufferAddressReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMATxBufferAddressReg   pHwiDMATxBufferAddressReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = pHwiDMATxBufferAddressReg->Address32bit;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMATxBufferAddressReg,
        4,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMATxBufferAddressReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMATxBufferAddressReg   pHwiDMATxBufferAddressReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMATxBufferAddressReg,
        4,
        &Value
        );
    
    pHwiDMATxBufferAddressReg->Address32bit = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMARxBufferAddressReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMARxBufferAddressReg   pHwiDMARxBufferAddressReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = pHwiDMARxBufferAddressReg->Address32bit;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMARxBufferAddressReg,
        4,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMARxBufferAddressReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMARxBufferAddressReg   pHwiDMARxBufferAddressReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMARxBufferAddressReg,
        4,
        &Value
        );
    
    pHwiDMARxBufferAddressReg->Address32bit = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMAInterruptEnableReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMAInterruptEnableReg   pHwiDMAInterruptEnableReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptEnableReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _SetDataField(Value, HwiDMAInterruptEnableReg_TxSegment, pHwiDMAInterruptEnableReg->TxSegment);
    _SetDataField(Value, HwiDMAInterruptEnableReg_RxSegment, pHwiDMAInterruptEnableReg->RxSegment);
    _SetDataField(Value, HwiDMAInterruptEnableReg_ModemStatus, pHwiDMAInterruptEnableReg->ModemStatus);
    _SetDataField(Value, HwiDMAInterruptEnableReg_RxSegmentOverrun, pHwiDMAInterruptEnableReg->RxSegmentOverrun);
    _SetDataField(Value, HwiDMAInterruptEnableReg_UARTOverrun, pHwiDMAInterruptEnableReg->UARTOverrun);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptEnableReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMAInterruptEnableReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMAInterruptEnableReg   pHwiDMAInterruptEnableReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptEnableReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    _GetDataField(Value, HwiDMAInterruptEnableReg_TxSegment, pHwiDMAInterruptEnableReg->TxSegment);
    _GetDataField(Value, HwiDMAInterruptEnableReg_RxSegment, pHwiDMAInterruptEnableReg->RxSegment);
    _GetDataField(Value, HwiDMAInterruptEnableReg_ModemStatus, pHwiDMAInterruptEnableReg->ModemStatus);
    _GetDataField(Value, HwiDMAInterruptEnableReg_RxSegmentOverrun, pHwiDMAInterruptEnableReg->RxSegmentOverrun);
    _GetDataField(Value, HwiDMAInterruptEnableReg_UARTOverrun, pHwiDMAInterruptEnableReg->UARTOverrun);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMAInterruptStatusReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMAInterruptStatusReg   pHwiDMAInterruptStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptStatusReg,
        4,
        &Value
        );
    
    _SetDataField(Value, HwiDMAInterruptStatusReg_TxSegment0, pHwiDMAInterruptStatusReg->TxSegment0);
    _SetDataField(Value, HwiDMAInterruptStatusReg_TxSegment1, pHwiDMAInterruptStatusReg->TxSegment1);
    _SetDataField(Value, HwiDMAInterruptStatusReg_RxSegment0, pHwiDMAInterruptStatusReg->RxSegment0);
    _SetDataField(Value, HwiDMAInterruptStatusReg_RxSegment1, pHwiDMAInterruptStatusReg->RxSegment1);
    _SetDataField(Value, HwiDMAInterruptStatusReg_ModemStatus, pHwiDMAInterruptStatusReg->ModemStatus);
    _SetDataField(Value, HwiDMAInterruptStatusReg_RxSegmentOverrun, pHwiDMAInterruptStatusReg->RxSegmentOverrun);
    _SetDataField(Value, HwiDMAInterruptStatusReg_UARTOverrun, pHwiDMAInterruptStatusReg->UARTOverrun);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx0Ready, pHwiDMAInterruptStatusReg->Rx0Ready);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx0LineError, pHwiDMAInterruptStatusReg->Rx0LineError);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx0Timeout, pHwiDMAInterruptStatusReg->Rx0Timeout);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx1Ready, pHwiDMAInterruptStatusReg->Rx1Ready);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx1LineError, pHwiDMAInterruptStatusReg->Rx1LineError);
    //_SetDataField(Value, HwiDMAInterruptStatusReg_Rx1Timeout, pHwiDMAInterruptStatusReg->Rx1Timeout);
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptStatusReg,
        4,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMAInterruptStatusReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMAInterruptStatusReg   pHwiDMAInterruptStatusReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMAInterruptStatusReg,
        4,
        &Value
        );
    
    _GetDataField(Value, HwiDMAInterruptStatusReg_TxSegment0, pHwiDMAInterruptStatusReg->TxSegment0);
    _GetDataField(Value, HwiDMAInterruptStatusReg_TxSegment1, pHwiDMAInterruptStatusReg->TxSegment1);
    _GetDataField(Value, HwiDMAInterruptStatusReg_RxSegment0, pHwiDMAInterruptStatusReg->RxSegment0);
    _GetDataField(Value, HwiDMAInterruptStatusReg_RxSegment1, pHwiDMAInterruptStatusReg->RxSegment1);
    _GetDataField(Value, HwiDMAInterruptStatusReg_ModemStatus, pHwiDMAInterruptStatusReg->ModemStatus);
    _GetDataField(Value, HwiDMAInterruptStatusReg_RxSegmentOverrun, pHwiDMAInterruptStatusReg->RxSegmentOverrun);
    _GetDataField(Value, HwiDMAInterruptStatusReg_UARTOverrun, pHwiDMAInterruptStatusReg->UARTOverrun);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx0Ready, pHwiDMAInterruptStatusReg->Rx0Ready);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx0LineError, pHwiDMAInterruptStatusReg->Rx0LineError);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx0Timeout, pHwiDMAInterruptStatusReg->Rx0Timeout);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx1Ready, pHwiDMAInterruptStatusReg->Rx1Ready);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx1LineError, pHwiDMAInterruptStatusReg->Rx1LineError);
    _GetDataField(Value, HwiDMAInterruptStatusReg_Rx1Timeout, pHwiDMAInterruptStatusReg->Rx1Timeout);
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMATx0DataLengthReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMATx0DataLengthReg     pHwiDMATx0DataLengthReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = pHwiDMATx0DataLengthReg->DataLength;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMATx0DataLengthReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_SetHwiDMATx1DataLengthReg(
    IN      PMappedBusAddress           hMappedRegisters,
    IN      PHwiDMATx1DataLengthReg     pHwiDMATx1DataLengthReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = pHwiDMATx1DataLengthReg->DataLength;
    
    BusDeviceIO_Write(
        hMappedRegisters,
        EUARTRegOffset_HwiDMATx1DataLengthReg,
        EUARTRegOffset_Size,
        Value
        );
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMARx0DataCountReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMARx0DataCountReg      pHwiDMARx0DataCountReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMARx0DataCountReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiDMARx0DataCountReg->DataCount = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}


VOID
_GetHwiDMARx1DataCountReg(
    IN      PMappedBusAddress           hMappedRegisters,
        OUT PHwiDMARx1DataCountReg      pHwiDMARx1DataCountReg
    )
{
    //VOID                    funcresult;
    //ULONG                       result;
    
    ULONG                       Value;
    
    //
    // initialize local variables
    //
    
    //funcresult = FR_Success;
    
    //
    // check parameters
    //
    
    // at the Hwi level, we dont validate the input parameter.
    
    //
    // function body
    //
    
    Value = 0;
    
    BusDeviceIO_Read(
        hMappedRegisters,
        EUARTRegOffset_HwiDMARx1DataCountReg,
        EUARTRegOffset_Size,
        &Value
        );
    
    pHwiDMARx1DataCountReg->DataCount = Value;
    
    goto funcexit;
funcexit:

    //
    // free local buffers
    //
    
    //
    // unsuccessful handle
    //
    
    //return funcresult;
    return ;
}